import java.util.ArrayList;
import java.util.List;


public class MovieSearch {

	
	public static void main(String[] args) {
		// TODO Auto-generated method stub

		Movie movieA = new Movie("Veggie Tales", "1990", "Talking Vegetables");
		Movie movieB = new Movie("Thomas the Train", "2001", "A train named Thomas");
		Movie movieC = new Movie("Rocky", "1985", "A tale of a fighter");
		
		ArrayList<Movie> movies1 = new ArrayList<Movie>();
		movies1.add(movieA);
		movies1.add(movieB);
		
		ArrayList<Movie> movies2 = new ArrayList<Movie>();
		movies2.add(movieA);
		movies2.add(movieC);
		
		Theater theaterLaurel = new Theater("Ritz", "08054");
		theaterLaurel.setMovies(movies1);

		Theater theaterCherryHill = new Theater("Cineplex", "08003");
		theaterCherryHill.setMovies(movies2);
		
		List<Theater> theatersList= new ArrayList<Theater>();
		theatersList.add(theaterLaurel);
		theatersList.add(theaterCherryHill);
		
		if (args !=null)
		{
			String zipSearch = args[0];
			Theater foundTheater = matchZip(zipSearch, theatersList) ;
			System.out.println("Matching theater to your zip is:"+ foundTheater.getName());
			System.out.println("Movies playing are:");

			for (Movie m:foundTheater.getMovies())
			{
				System.out.println(m.getTitle());
			}
		}
		
	}
	
	public static Theater matchZip(String zip, List<Theater> theatersList)
	{
		for (Theater t: theatersList)
		{
			if (t.getZipCode().equals(zip))
					return t;
		}
		return null;
	}

}
